#Copyright (C)  This program is free software: you can 
#redistribute it and/or modify it under the terms of the GNU General Public 
#License as published by the Free Software Foundation, either version 3 of the 
#License, or (at your option) any later version. This program is distributed in 
#the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the 
#implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
#GNU General Public License for more details.

#To obtain a copy of the general licence GNU General Public License contact 
#the Economic Regulation Authority at:
#Mail address PO Box 8469, PERTH BC WA 6849

#The GNU General Public License does not permit incorporating this program into proprietary programs. 
#---------------------------------------------------------------------------------------------------------

# File Name:     DRP automation.R

# Date:          2018-12-10

# Custodian:     Jason Dignard
# Role:          Principal Regulatory Advisor
# Authority:     Economic Regulation Authority
# Email:         jason.dignard @erawa.com.au

# Author:        Rohan Sadler
# Role:          Statistician
# Company:       Pink Lake Analytics
# Email:         rohan.sadler@pinklake.com.au

# Acknowledgements: 
#                CEG - for np library implementation to generalise Reserve Bank kernel estimate
#                      in estimateCostofDebt function in drp_functions.R

# libraries ------------------------------------------
#library(Rblpapi)
library(NMOF)
library(readxl)
library(sm)
library(mgcv)
#library(olsrr)
library(lubridate)
library(openxlsx)
library(YieldCurve)
library(np)

# set working directory
## set working directory to level above where you have code;
##   or edit 'source' path below as required.
#setwd("~/DRP Methods")

# source files
source("code/drp_functions.R")

# inputs  --------------------------------------------
# data request and shaping
yieldData<-extractYield()

# estimation of each yield curve model
costDebt<-estimateCostOfDebt(inData=yieldData$yields,sigma=yieldData$gkSigma)

# shape model estimates into a debt risk premium estimate
fList<-buildOutput()
 
# allow for a function here to format the output excel workbook into
#  a more human readable format.
cat("Your output file has been saved to:\n",fList$fString,"\n")

write.xlsx(fList$Output,fList$fString ,asTable=TRUE,colNames=FALSE,overwrite=TRUE)


#------------------
# Develop option to write out entire workbook through openxlsx
#    This would format the R page
#    And insert it into the start of workbook
# wb <- loadWorkbook(fChoose)
# addWorksheet(wb,"DRP output using R")
# 
# writeDataTable(wb, "DRP output using R",x=outputDF,colNames=FALSE)
# # Save file
# saveWorkbook(wb, file = fChoose,overwrite=TRUE)
